/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.rendering.lighting;

import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Mesh;
import com.badlogic.gdx.graphics.VertexAttribute;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Disposable;
import technology.rocketjump.undermount.mapping.tile.wall.Edge;

public class PointLightMesh
implements Disposable {
    private Mesh internalMesh;
    private static int MAX_NUM_TRIANGLES = 2000;
    private static final int NUM_INDEX_PER_TRIANGLE = 3;
    private static final String LIGHT_POSITION_UNIFORM = "u_lightPosition";
    private final Matrix4 combinedMatrix = new Matrix4();
    private final float[] vertices;
    private final short[] indices;
    private int vertexComponentIndex = 0;
    private final int VERTEX_SIZE = 4;
    private Vector2 worldPosition;

    public PointLightMesh() {
        int MAX_VERTICES = MAX_NUM_TRIANGLES * 4 * 3;
        this.vertices = new float[MAX_VERTICES];
        int MAX_INDICES = MAX_NUM_TRIANGLES * 3;
        this.indices = new short[MAX_INDICES];
        this.internalMesh = new Mesh(Mesh.VertexDataType.VertexArray, false, MAX_VERTICES, MAX_INDICES, new VertexAttribute(1, 2, "a_position"), new VertexAttribute(1, 2, "a_positionRelativeToLight"));
        int vertexCursor = 0;
        int indexCursor = 0;
        while (indexCursor < MAX_INDICES) {
            this.indices[indexCursor] = (short)vertexCursor;
            this.indices[indexCursor + 1] = (short)(vertexCursor + 1);
            this.indices[indexCursor + 2] = (short)(vertexCursor + 2);
            indexCursor += 3;
            vertexCursor += 3;
        }
        this.internalMesh.setIndices(this.indices);
    }

    public void updateGeometry(Vector2 worldPosition, float radius, Array<Edge> lightPolygonEdges) {
        this.worldPosition = worldPosition;
        this.vertexComponentIndex = 0;
        for (Edge polygonEdge : lightPolygonEdges) {
            if (polygonEdge.getPointA() == null || polygonEdge.getPointB() == null) continue;
            this.vertices[this.vertexComponentIndex++] = worldPosition.x;
            this.vertices[this.vertexComponentIndex++] = worldPosition.y;
            this.vertices[this.vertexComponentIndex++] = 0.0f;
            this.vertices[this.vertexComponentIndex++] = 0.0f;
            this.vertices[this.vertexComponentIndex++] = worldPosition.x + polygonEdge.getPointA().x;
            this.vertices[this.vertexComponentIndex++] = worldPosition.y + polygonEdge.getPointA().y;
            this.vertices[this.vertexComponentIndex++] = polygonEdge.getPointA().x / radius;
            this.vertices[this.vertexComponentIndex++] = polygonEdge.getPointA().y / radius;
            this.vertices[this.vertexComponentIndex++] = worldPosition.x + polygonEdge.getPointB().x;
            this.vertices[this.vertexComponentIndex++] = worldPosition.y + polygonEdge.getPointB().y;
            this.vertices[this.vertexComponentIndex++] = polygonEdge.getPointB().x / radius;
            this.vertices[this.vertexComponentIndex++] = polygonEdge.getPointB().y / radius;
        }
        this.internalMesh.setVertices(this.vertices, 0, this.vertexComponentIndex);
        this.internalMesh.getIndicesBuffer().position(0);
        this.internalMesh.getIndicesBuffer().limit(lightPolygonEdges.size * 3);
    }

    public void render(Camera camera, Color color, ShaderProgram lightShader) {
        if (this.worldPosition == null) {
            return;
        }
        Vector3 lightPosition = new Vector3(this.worldPosition.x, this.worldPosition.y, 0.5f).mul(camera.combined);
        lightPosition.z = 0.1f;
        lightShader.setUniformf(LIGHT_POSITION_UNIFORM, lightPosition);
        lightShader.setUniformf("u_lightColor", new Vector3(color.r, color.g, color.b));
        this.combinedMatrix.set(camera.combined);
        lightShader.setUniformMatrix("u_projTrans", this.combinedMatrix);
        this.internalMesh.render(lightShader, 4, 0, this.internalMesh.getIndicesBuffer().limit());
    }

    @Override
    public void dispose() {
        this.internalMesh.dispose();
    }
}

